/*
 * Decompiled with CFR 0.152.
 */
package net.peanuuutz.tomlkt.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.serialization.descriptors.SerialKind;
import net.peanuuutz.tomlkt.internal.ConflictEntryException;
import net.peanuuutz.tomlkt.internal.IncompleteException;
import net.peanuuutz.tomlkt.internal.NonPrimitiveKeyException;
import net.peanuuutz.tomlkt.internal.PolymorphicCollectionException;
import net.peanuuutz.tomlkt.internal.StringUtilsKt;
import net.peanuuutz.tomlkt.internal.TomlSerializationExceptionsKt;
import net.peanuuutz.tomlkt.internal.UnexpectedTokenException;
import net.peanuuutz.tomlkt.internal.UnknownKeyException;
import net.peanuuutz.tomlkt.internal.UnsupportedSerialKindException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0002\u001a\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00010\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0012\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u001a\b\u0010\r\u001a\u00020\u0003H\u0000\u001a \u0010\u000e\u001a\u00020\u00032\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0000\u001a\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"PolymorphicCollection", "", "throwConflictEntry", "", "path", "", "Lnet/peanuuutz/tomlkt/internal/Path;", "line", "", "throwIncomplete", "throwNonPrimitiveKey", "key", "", "throwPolymorphicCollection", "throwSubclassNotRegistered", "subclass", "Lkotlin/reflect/KClass;", "baseClass", "throwUnexpectedToken", "token", "", "throwUnknownKey", "throwUnsupportedSerialKind", "message", "kind", "Lkotlinx/serialization/descriptors/SerialKind;", "tomlkt"})
public final class TomlSerializationExceptionsKt {
    @NotNull
    private static final String PolymorphicCollection = "Collection-like type cannot be polymorphic";

    @NotNull
    public static final Void throwSubclassNotRegistered(@NotNull KClass<?> subclass, @NotNull KClass<?> baseClass) {
        Intrinsics.checkNotNullParameter(subclass, (String)"subclass");
        Intrinsics.checkNotNullParameter(baseClass, (String)"baseClass");
        String message2 = "Class " + subclass.getSimpleName() + " is not registered for polymorphic serialization in the scope of " + baseClass.getSimpleName() + ". Mark " + baseClass.getSimpleName() + " as sealed or register " + subclass.getSimpleName() + " in a serializers module (and switch out the default one in the Toml {  } factory function)";
        throw new IllegalStateException(message2.toString());
    }

    @NotNull
    public static final Void throwNonPrimitiveKey(@Nullable Object key) {
        throw new NonPrimitiveKeyException(String.valueOf(key));
    }

    @NotNull
    public static final Void throwUnsupportedSerialKind(@NotNull SerialKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        throw new UnsupportedSerialKindException(kind.toString());
    }

    @NotNull
    public static final Void throwUnsupportedSerialKind(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        throw new UnsupportedSerialKindException(message2);
    }

    @NotNull
    public static final Void throwPolymorphicCollection() {
        throw new PolymorphicCollectionException();
    }

    @NotNull
    public static final Void throwUnexpectedToken(char token, int line) {
        String tokenRepresentation = token != '\'' ? StringUtilsKt.escape$default(token, false, 1, null) : "\\'";
        String message2 = '\'' + tokenRepresentation + "' (L" + line + ')';
        throw new UnexpectedTokenException(message2);
    }

    @NotNull
    public static final Void throwIncomplete(int line) {
        throw new IncompleteException("(L" + line + ')');
    }

    @NotNull
    public static final Void throwConflictEntry(@NotNull List<String> path, int line) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        String message2 = CollectionsKt.joinToString$default((Iterable)path, (CharSequence)".", null, (CharSequence)(" (L" + line + ')'), (int)0, null, (Function1)throwConflictEntry.message.1.INSTANCE, (int)26, null);
        throw new ConflictEntryException(message2);
    }

    @NotNull
    public static final Void throwUnknownKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        throw new UnknownKeyException(key);
    }
}

